/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.HealpixAllsky;
import cds.aladin.HealpixKey;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImageCube;
import cds.aladin.PointD;
import cds.aladin.TreeObjDir;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.util.Hashtable;

public class PlanBGCube
extends PlanBG {
    public int depth;
    protected double z = 0.0;
    protected int zInit;
    protected boolean pause;
    private double crval3;
    private double crpix3;
    private double cdelt3;
    private String cunit3;
    protected boolean fromCanal;
    private double ox = -1.0;
    private double oy = -1.0;
    private double[] bit8 = new double[10000];
    private Hashtable<String, Integer> previousWorkingFrame = new Hashtable();
    private LoadingImmediatelyThread loadingThread = null;

    protected PlanBGCube(Aladin aladin) {
        super(aladin);
        this.type = 22;
    }

    protected PlanBGCube(Aladin aladin, TreeObjDir gluSky, String label, Coord c, double radius, String startingTaskId) {
        super(aladin, gluSky, label, c, radius, startingTaskId);
        aladin.log(Plan.Tp[this.type], label);
    }

    @Override
    protected void setSpecificParams(TreeObjDir gluSky) {
        super.setSpecificParams(gluSky);
        this.depth = gluSky.cubeDepth;
        this.zInit = gluSky.cubeFirstFrame;
        this.z = this.zInit;
        this.pause = true;
        this.scanCubeProperties();
    }

    @Override
    protected String getFrameLabel(int i) {
        if (!this.active) {
            return super.getFrameLabel(i);
        }
        if (this.fromCanal) {
            return this.getCanalValue(i);
        }
        String s = this.prop.getProperty("obs_title_" + i);
        if (s == null) {
            s = this.prop.getProperty("label_" + i);
        }
        return s != null ? s : this.label;
    }

    protected String getCanalValue(int n) {
        return PlanImageCube.getCanalValue(n, this.crpix3, this.cdelt3, this.crval3, this.cunit3);
    }

    @Override
    protected boolean Free() {
        this.stopLoadingImmediately();
        return super.Free();
    }

    protected boolean scanCubeProperties() {
        try {
            MyProperties prop = this.loadPropertieFile();
            if (prop == null) {
                throw new Exception();
            }
            String s = prop.getProperty("hips_cube_depth");
            if (s == null) {
                s = prop.getProperty("cubeDepth");
            }
            if (s != null) {
                try {
                    this.depth = Integer.parseInt(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "PlanBGCube error on cubeDepth property [" + s + "]");
                }
            }
            if ((s = prop.getProperty("hips_cube_firstframe")) == null) {
                s = prop.getProperty("cubeFirstFrame");
            }
            if (s != null) {
                try {
                    this.zInit = Integer.parseInt(s);
                    this.z = this.zInit;
                }
                catch (Exception e) {
                    Aladin.trace(3, "PlanBGCube error on cubeFirstFrame property [" + s + "]");
                }
            }
            try {
                s = prop.getProperty("data_cube_crpix3");
                this.crpix3 = Double.parseDouble(s);
                s = prop.getProperty("data_cube_crval3");
                this.crval3 = Double.parseDouble(s);
                s = prop.getProperty("data_cube_cdelt3");
                this.cdelt3 = Double.parseDouble(s);
                this.fromCanal = true;
                this.cunit3 = prop.getProperty("data_cube_cunit3");
                if (this.cunit3 == null) {
                    this.cunit3 = prop.getProperty("data_cube_bunit3");
                }
            }
            catch (Exception e) {
                this.fromCanal = false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected void paramByTreeNode(TreeObjDir gSky, Coord c, double radius) {
        super.paramByTreeNode(gSky, c, radius);
        this.depth = gSky.cubeDepth;
        this.z = gSky.cubeFirstFrame;
    }

    @Override
    protected void activeCubePixels(ViewSimple v) {
        if (!this.setCubeFrame(v.cubeControl.lastFrame)) {
            return;
        }
        v.cubeControl.startTime = System.currentTimeMillis();
        this.askForRepaint();
    }

    @Override
    protected boolean setCubeFrame(double frameLevel) {
        if (this.z == frameLevel) {
            return false;
        }
        this.z = frameLevel;
        return true;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        int[] n = this.aladin.view.getNumView(this);
        if (n != null) {
            for (int i : n) {
                this.aladin.view.viewSimple[n[i]].cubeControl.nbFrame = depth;
            }
        }
    }

    @Override
    protected void setZ(double initFrame) {
        this.z = initFrame;
    }

    @Override
    protected double getZ() {
        return this.z;
    }

    @Override
    protected double getZ(ViewSimple v) {
        if (v.pref == this) {
            int f = v.cubeControl.getCurrentFrameIndex();
            if (f == -1) {
                f = v.cubeControl.lastFrame = this.zInit;
            }
            return f;
        }
        return this.z;
    }

    @Override
    protected void setPause(boolean t, ViewSimple v) {
        if (t == this.pause) {
            return;
        }
        this.pause = t;
        if (!this.pause) {
            this.loadingImmediately(v);
        }
    }

    @Override
    protected boolean isPause() {
        return this.pause;
    }

    @Override
    public int getDepth() {
        return this.depth == -1 ? 1 : this.depth;
    }

    @Override
    protected int getInitDelay() {
        return 500;
    }

    @Override
    protected byte getPixel8bit(int z, double x, double y) {
        double pix;
        ViewSimple v = this.aladin.view.getCurrentView();
        PointD p = v.getPosition(x, y);
        if (p.x != this.ox || p.y != this.oy) {
            for (int i = 0; i < this.bit8.length; ++i) {
                this.bit8[i] = Double.NaN;
            }
            this.ox = p.x;
            this.oy = p.y;
        }
        if (!Double.isNaN(this.bit8[z])) {
            pix = this.bit8[z];
            System.out.println(pix + " (from cache)");
        } else {
            pix = this.bit8[z] = this.getOnePixelFromCache(this.projd, p.x, p.y, -1, z, 3);
        }
        if (Double.isNaN(pix)) {
            pix = 0.0;
        }
        return (byte)((int)pix & 0xFF);
    }

    @Override
    protected String key(HealpixKey h) {
        return this.key(h.order, h.npix, h.z);
    }

    @Override
    protected String key(int order, long npix) {
        return this.key(order, npix, (int)this.z);
    }

    @Override
    public HealpixKey askForHealpix(int order, long npix) {
        if (this.isPause()) {
            return super.askForHealpix(order, npix);
        }
        this.readyAfterDraw = false;
        HealpixKey pixAsk = new HealpixKey(this, order, npix, 3);
        this.pixList.put(this.key(order, npix), pixAsk);
        return pixAsk;
    }

    @Override
    protected HealpixKey getHealpixPreviousFrame(int order, long npix) {
        String key = super.key(order, npix);
        Integer z2 = this.previousWorkingFrame.get(key);
        if (z2 == null) {
            return null;
        }
        int z1 = z2;
        HealpixKey h = (HealpixKey)this.pixList.get(this.key(order, npix, z1));
        if (h == null || h.getStatus() != 6) {
            this.previousWorkingFrame.remove(key);
            return null;
        }
        return h;
    }

    @Override
    protected void setHealpixPreviousFrame(int order, long npix) {
        int z = (int)this.getZ();
        String key = super.key(order, npix);
        this.previousWorkingFrame.put(key, new Integer(z));
    }

    protected void loadingImmediately(ViewSimple v) {
        this.loadingThread = new LoadingImmediatelyThread(this, v, (int)this.getZ() + 1);
        this.loadingThread.start();
    }

    protected void stopLoadingImmediately() {
        if (this.loadingThread != null) {
            this.loadingThread.abort();
        }
    }

    protected int getCurrentFrameReady() {
        if (this.isPause() || this.loadingThread == null) {
            return -1;
        }
        return this.loadingThread.getZ();
    }

    class LoadingImmediatelyThread
    extends Thread {
        private int initZ;
        private int z1 = 0;
        private boolean encore;
        private PlanBGCube plan;
        private ViewSimple v;
        int initOrder;
        Coord center;

        LoadingImmediatelyThread(PlanBGCube plan, ViewSimple v, int z) {
            this.plan = plan;
            this.v = v;
            this.z1 = z;
        }

        void abort() {
            this.encore = false;
        }

        int getZ() {
            return this.z1 - 1;
        }

        private boolean onZone() {
            int o = Math.min(PlanBGCube.this.maxOrder(this.v), PlanBGCube.this.maxOrder);
            if (o != this.initOrder) {
                return false;
            }
            if (o < PlanBGCube.this.getMinOrder() || this.v.isAllSky()) {
                return true;
            }
            Coord c = PlanBGCube.this.getCooCentre(this.v);
            return c.al == this.center.al && c.del == this.center.del;
        }

        @Override
        public void run() {
            this.encore = true;
            block0: while (this.encore) {
                boolean lowResolution;
                int order;
                this.initZ = this.z1 = (int)this.plan.getZ(this.v) + 1;
                this.center = PlanBGCube.this.getCooCentre(this.v);
                this.initOrder = order = Math.min(PlanBGCube.this.maxOrder(this.v), PlanBGCube.this.maxOrder);
                long[] pix = null;
                boolean bl = lowResolution = this.v.isAllSky() || order <= PlanBGCube.this.getMinOrder();
                if (!lowResolution) {
                    pix = PlanBGCube.this.getPixList(this.v, this.center, order);
                    for (int j = 0; j < pix.length; ++j) {
                        if (PlanBGCube.this.moc != null && !PlanBGCube.this.moc.isIntersecting(order, pix[j])) {
                            pix[j] = -1L;
                            continue;
                        }
                        if (!new HealpixKey(this.plan, order, pix[j], 0).isOutView(this.v)) continue;
                        pix[j] = -1L;
                    }
                }
                int i = 0;
                while (i < PlanBGCube.this.depth && this.encore) {
                    if (PlanBGCube.this.isPause()) {
                        this.encore = false;
                        break;
                    }
                    if (this.z1 >= PlanBGCube.this.depth) {
                        this.z1 = 0;
                    }
                    if (!this.onZone()) break;
                    if (pix == null) {
                        HealpixAllsky healpixAllsky = new HealpixAllsky((PlanBG)this.plan, PlanBGCube.this.getMinOrder(), this.z1, 2);
                    } else {
                        for (int j = 0; j < pix.length; ++j) {
                            String key;
                            if (pix[j] == -1L || PlanBGCube.this.pixList.get(key = PlanBGCube.this.key(order, pix[j], this.z1)) != null) continue;
                            HealpixKey h = new HealpixKey(this.plan, order, pix[j], this.z1, 2);
                            PlanBGCube.this.pixList.put(key, h);
                        }
                    }
                    if (PlanBGCube.this.ox != -1.0) {
                        ((PlanBGCube)PlanBGCube.this).bit8[this.z1] = PlanBGCube.this.getOnePixelFromCache(PlanBGCube.this.projd, PlanBGCube.this.ox, PlanBGCube.this.oy, -1, this.z1, 3);
                    }
                    ++i;
                    ++this.z1;
                }
                while (this.encore && this.onZone()) {
                    this.z1 = 0;
                    if (PlanBGCube.this.isPause()) {
                        this.encore = false;
                        continue block0;
                    }
                    Util.pause(1000);
                }
            }
        }
    }
}

